<?php
/* --------------------------------------------------------------
   HubPayPalButtonSettings.inc.php 2022-08-03
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2022 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

use HubPublic\Http\CurlRequest;

MainFactory::load_class('HubPayPalSettings');

class HubPayPalButtonSettings extends HubPayPalSettings
{
    /**
     * Returns an array representing a PayPal Smart Buttons configuration.
     *
     * @return array
     */
    public function getButtonSettings(): array
    {
        $paypalLocaleFactory = MainFactory::create('HubPayPalLocaleFactory');
        $jsSdkSettings = $this->getJavascriptSource();
        // no using vault when user have'nt login
        if (!isset($_SESSION['customer_id']) || !isset($_SESSION['customer_encryption_key'])) {
            $jsSdkSettings['useVault'] = false;
        }
        $buttonConfig = [
            'env'                  => $this->config->getEnv() === 'sandbox' ? 'sandbox' : 'live',
            'commit'               => false,
            'style'                => [
                'label'        => $this->config->getStyleLabel(),
                'shape'        => $this->config->getStyleShape(),
                'color'        => $this->config->getStyleColor(),
                'layout'       => $this->config->getStyleLayout(),
                'tagline'      => $this->config->isStyleTagline(),
            ],
            'locale' => $paypalLocaleFactory->getLocaleByLanguageAndCountry($_SESSION['language_code'],
                                                                            $_SESSION['delivery_zone'] ?? ''),
            'fundingCardAllowed'   => $this->config->isFundingCardAllowed(),
            'fundingELVAllowed'    => $this->config->isFundingELVAllowed(),
            'fundingCreditAllowed' => $this->config->isFundingCreditAllowed(),
            'createPaymentUrl'     => '',
            'authorizedPaymentUrl' => '',
            'checkoutUrl'          => '',
        ];
        // failure handler to avoid side effect.
        if ($jsSdkSettings['useVault'] === true) {
            try {
                $vaultToken = $this->getUserVaultTokenFromSession();
                if ($vaultToken) {
                    $buttonConfig['vaultToken'] = $vaultToken;
                }
            } catch (Exception $e) {
                $jsSdkSettings['useVault'] = false;
            }
        }

        return array_merge($buttonConfig, $jsSdkSettings);
    }

    public function getECMButtonSettings()
    {
        $jsSdkSettings = $this->getJavascriptSource('ecm');
        $ecmButtonConfig = $this->getButtonSettings();
        $ecmButtonConfig['style']['layout'] = 'horizontal';
        $ecmButtonConfig['style']['label'] = 'checkout';
        
        return array_merge($ecmButtonConfig, $jsSdkSettings);
    }


}
